/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CUDPSocket.h,v 1.1 1999/10/26 02:05:07 jason Exp $
____________________________________________________________________________*/

#pragma once 

#include "CInternetSocket.h"

class CUDPSocket : public CInternetSocket {
protected:
	typedef CInternetSocket	inherited;
	
public:
								CUDPSocket();
	virtual						~CUDPSocket();
	
	virtual void				Bind(const PGPSocketAddressInternet *
										inAddress);
	virtual void				Connect(const PGPSocketAddressInternet *
										inAddress);
	virtual SInt32				Send(const void * inBuffer, SInt32 inLength,
									SInt32 inFlags);
	virtual SInt32				SendTo(const void * inBuffer, SInt32 inLength,
									const PGPSocketAddressInternet *
										inAddress);
	virtual SInt32				Receive(void * outBuffer, SInt32 inLength,
									SInt32 inFlags);
	virtual SInt32				ReceiveFrom(void * outBuffer, SInt32 inSize,
									PGPSocketAddressInternet * outAddress,
								SInt32 * ioAddressLength);
	virtual void				Listen(SInt32 inMaxBacklog);
	virtual CSocket *			Accept(PGPSocketAddressInternet * outAddress,
									SInt32 * ioAddressLength);
	
	virtual void				GetPeerName(PGPSocketAddressInternet * outName);

protected:
	Boolean						mConnected;
	PGPSocketAddressInternet	mConnectAddress;
	Boolean						mBound;
};